#include <Internet.h>
#include <Controller.h>


const int BOOT_BUTTON_PIN = 0;

Internet internet(0);
Controller controller(0);


void setup(){
	Serial.begin(115200);
	controller.init();
	internet.init();
}

void loop(){

	//Wait X seconds
	delay(3 * 1000);

	Serial.println("++++++++++++++++++++++++");
	Serial.println("Main Loop here.");
	checkIfBootButtonIsPressed();


	controller.loop(internet);

}


void checkIfBootButtonIsPressed(){

	if (digitalRead(BOOT_BUTTON_PIN) == LOW){ // Check if button has been pressed
	   
	   while (digitalRead(BOOT_BUTTON_PIN) == LOW){}; // Wait for button to be released

	   //Boot button was pressed.

	   //Reset WiFi
	   Serial.println("Boot button was pressed while running, will reset WiFi");

	   internet.setSSID("");
	   internet.setPW("");
	   internet.startCredentialCollection();
	   // internet.init();
	   //if there are issues with esp not disconnecting from previous network may need to call WiFi.disconnect();

	}


}

